# main.py - فایل اصلی اجرای ربات

import asyncio
import logging
from telegram.ext import Application

from config import BOT_TOKEN
from database import init_database, Database
from handlers import get_auth_handlers, get_registration_handler, get_exam_handlers, get_admin_handlers, get_user_design_handlers, get_preexam_handlers, get_anonymous_handlers, get_services_handlers


# تنظیم لاگینگ
logging.basicConfig(
    format="%(asctime)s - %(name)s - %(levelname)s - %(message)s",
    level=logging.INFO
)
logger = logging.getLogger(__name__)


async def post_init(application: Application) -> None:
    """تابع راه‌اندازی اولیه بعد از ایجاد Application."""
    await init_database()
    logger.info("✅ ربات آماده کار است!")


async def post_shutdown(application: Application) -> None:
    """تابع پاکسازی هنگام خاموش شدن ربات."""
    await Database.close()
    logger.info("🔴 ربات خاموش شد.")


def main() -> None:
    """تابع اصلی اجرای ربات."""
    # بررسی توکن
    if BOT_TOKEN == "YOUR_BOT_TOKEN_HERE":
        print("❌ خطا: لطفاً توکن ربات را در فایل config.py تنظیم کنید!")
        print("توکن را از @BotFather در تلگرام دریافت کنید.")
        return
    
    # ساخت Application
    application = (
        Application.builder()
        .token(BOT_TOKEN)
        .post_init(post_init)
        .post_shutdown(post_shutdown)
        .build()
    )
    
    # ثبت هندلرهای احراز هویت
    for handler in get_auth_handlers():
        application.add_handler(handler)
    
    # ثبت ConversationHandler ثبت‌نام
    application.add_handler(get_registration_handler())
    
    # ثبت هندلرهای ادمین (باید قبل از هندلرهای آزمون باشد)
    for handler in get_admin_handlers():
        application.add_handler(handler)
    
    # ثبت هندلرهای طراحی تست و تست شانسی
    for handler in get_user_design_handlers():
        application.add_handler(handler)
    
    # ثبت هندلرهای پیام ناشناس
    for handler in get_anonymous_handlers():
        application.add_handler(handler)
    
    # ثبت هندلرهای خدمات و محصولات
    for handler in get_services_handlers():
        application.add_handler(handler)
    
    # ثبت هندلرهای پیش‌آزمون
    for handler in get_preexam_handlers():
        application.add_handler(handler)
    
    # ثبت هندلرهای آزمون
    for handler in get_exam_handlers():
        application.add_handler(handler)
    
    # اجرای ربات
    print("🚀 ربات در حال اجرا است... (Ctrl+C برای توقف)")
    application.run_polling(allowed_updates=["message", "callback_query"])


if __name__ == "__main__":
    main()
