# seed_questions.py - اضافه کردن سوالات تستی به دیتابیس

import asyncio
import aiosqlite
from config import DATABASE_PATH

# 20 سوال تستی ساختگی
SAMPLE_QUESTIONS = [
    {
        "text": "پایتخت ایران کدام شهر است؟",
        "option_a": "اصفهان",
        "option_b": "تهران",
        "option_c": "شیراز",
        "option_d": "مشهد",
        "correct_answer": "B",
        "explanation": "تهران از سال ۱۲۰۵ هجری شمسی پایتخت ایران است."
    },
    {
        "text": "کدام سیاره به سیاره سرخ معروف است؟",
        "option_a": "زمین",
        "option_b": "زحل",
        "option_c": "مریخ",
        "option_d": "مشتری",
        "correct_answer": "C",
        "explanation": "مریخ به دلیل وجود اکسید آهن در سطحش به سیاره سرخ معروف است."
    },
    {
        "text": "بزرگترین اقیانوس جهان کدام است؟",
        "option_a": "اقیانوس اطلس",
        "option_b": "اقیانوس هند",
        "option_c": "اقیانوس آرام",
        "option_d": "اقیانوس منجمد شمالی",
        "correct_answer": "C",
        "explanation": "اقیانوس آرام با مساحت ۱۶۵ میلیون کیلومتر مربع بزرگترین اقیانوس جهان است."
    },
    {
        "text": "فرمول شیمیایی آب کدام است؟",
        "option_a": "CO2",
        "option_b": "H2O",
        "option_c": "O2",
        "option_d": "NaCl",
        "correct_answer": "B",
        "explanation": "آب از دو اتم هیدروژن و یک اتم اکسیژن تشکیل شده است: H2O"
    },
    {
        "text": "جواب ۲۵ × ۴ چیست؟",
        "option_a": "۸۰",
        "option_b": "۹۰",
        "option_c": "۱۰۰",
        "option_d": "۱۱۰",
        "correct_answer": "C",
        "explanation": "۲۵ × ۴ = ۱۰۰"
    },
    {
        "text": "کدام زبان بیشترین تعداد گویشور را در جهان دارد؟",
        "option_a": "انگلیسی",
        "option_b": "اسپانیایی",
        "option_c": "چینی ماندارین",
        "option_d": "هندی",
        "correct_answer": "C",
        "explanation": "چینی ماندارین با بیش از ۱ میلیارد گویشور، پرگویشورترین زبان جهان است."
    },
    {
        "text": "کدام عنصر بیشترین فراوانی را در پوسته زمین دارد؟",
        "option_a": "آهن",
        "option_b": "اکسیژن",
        "option_c": "سیلیسیم",
        "option_d": "آلومینیوم",
        "correct_answer": "B",
        "explanation": "اکسیژن با ۴۶% فراوان‌ترین عنصر پوسته زمین است."
    },
    {
        "text": "شاهنامه اثر کیست؟",
        "option_a": "حافظ",
        "option_b": "سعدی",
        "option_c": "فردوسی",
        "option_d": "مولوی",
        "correct_answer": "C",
        "explanation": "شاهنامه بزرگترین حماسه ملی ایران، اثر ابوالقاسم فردوسی است."
    },
    {
        "text": "واحد اندازه‌گیری جریان الکتریکی چیست؟",
        "option_a": "ولت",
        "option_b": "آمپر",
        "option_c": "وات",
        "option_d": "اهم",
        "correct_answer": "B",
        "explanation": "آمپر واحد اندازه‌گیری جریان الکتریکی در سیستم SI است."
    },
    {
        "text": "کدام کشور بیشترین جمعیت را دارد؟",
        "option_a": "آمریکا",
        "option_b": "هند",
        "option_c": "چین",
        "option_d": "روسیه",
        "correct_answer": "B",
        "explanation": "هند با جمعیت بیش از ۱.۴ میلیارد نفر، پرجمعیت‌ترین کشور جهان است."
    },
    {
        "text": "سرعت نور در خلاء چقدر است؟",
        "option_a": "۱۰۰,۰۰۰ کیلومتر بر ثانیه",
        "option_b": "۲۰۰,۰۰۰ کیلومتر بر ثانیه",
        "option_c": "۳۰۰,۰۰۰ کیلومتر بر ثانیه",
        "option_d": "۴۰۰,۰۰۰ کیلومتر بر ثانیه",
        "correct_answer": "C",
        "explanation": "سرعت نور در خلاء حدود ۲۹۹,۷۹۲ کیلومتر بر ثانیه است."
    },
    {
        "text": "DNA مخفف چیست؟",
        "option_a": "Deoxyribonucleic Acid",
        "option_b": "Dinitrogen Acid",
        "option_c": "Dynamic Nuclear Acid",
        "option_d": "Direct Nucleic Acid",
        "correct_answer": "A",
        "explanation": "DNA مخفف Deoxyribonucleic Acid یا اسید دئوکسی‌ریبونوکلئیک است."
    },
    {
        "text": "بلندترین کوه جهان کدام است؟",
        "option_a": "کوه K2",
        "option_b": "کوه دماوند",
        "option_c": "کوه اورست",
        "option_d": "کوه کلیمانجارو",
        "correct_answer": "C",
        "explanation": "کوه اورست با ارتفاع ۸,۸۴۸ متر بلندترین کوه جهان است."
    },
    {
        "text": "کدام ویتامین در پوست با تابش نور خورشید ساخته می‌شود؟",
        "option_a": "ویتامین A",
        "option_b": "ویتامین B",
        "option_c": "ویتامین C",
        "option_d": "ویتامین D",
        "correct_answer": "D",
        "explanation": "ویتامین D با تابش اشعه UV خورشید در پوست ساخته می‌شود."
    },
    {
        "text": "جنگ جهانی دوم در چه سالی پایان یافت؟",
        "option_a": "۱۹۴۳",
        "option_b": "۱۹۴۴",
        "option_c": "۱۹۴۵",
        "option_d": "۱۹۴۶",
        "correct_answer": "C",
        "explanation": "جنگ جهانی دوم در سال ۱۹۴۵ با تسلیم ژاپن پایان یافت."
    },
    {
        "text": "کدام گاز بیشترین حجم اتمسفر زمین را تشکیل می‌دهد؟",
        "option_a": "اکسیژن",
        "option_b": "نیتروژن",
        "option_c": "کربن دی‌اکسید",
        "option_d": "آرگون",
        "correct_answer": "B",
        "explanation": "نیتروژن حدود ۷۸% حجم اتمسفر زمین را تشکیل می‌دهد."
    },
    {
        "text": "مساحت مربعی با ضلع ۵ سانتی‌متر چقدر است؟",
        "option_a": "۱۰ سانتی‌متر مربع",
        "option_b": "۲۰ سانتی‌متر مربع",
        "option_c": "۲۵ سانتی‌متر مربع",
        "option_d": "۳۰ سانتی‌متر مربع",
        "correct_answer": "C",
        "explanation": "مساحت مربع = ضلع × ضلع = ۵ × ۵ = ۲۵ سانتی‌متر مربع"
    },
    {
        "text": "کدام دانشمند نظریه نسبیت را ارائه کرد؟",
        "option_a": "نیوتن",
        "option_b": "اینشتین",
        "option_c": "گالیله",
        "option_d": "هاوکینگ",
        "correct_answer": "B",
        "explanation": "آلبرت اینشتین نظریه نسبیت خاص و عام را در قرن بیستم ارائه کرد."
    },
    {
        "text": "بزرگترین استخوان بدن انسان کدام است؟",
        "option_a": "استخوان ران",
        "option_b": "استخوان درشت‌نی",
        "option_c": "استخوان بازو",
        "option_d": "ستون فقرات",
        "correct_answer": "A",
        "explanation": "استخوان ران (فمور) بزرگترین و قوی‌ترین استخوان بدن است."
    },
    {
        "text": "کدام سیاره دارای بیشترین قمر طبیعی است؟",
        "option_a": "مشتری",
        "option_b": "زحل",
        "option_c": "اورانوس",
        "option_d": "نپتون",
        "correct_answer": "B",
        "explanation": "زحل با بیش از ۱۴۰ قمر شناخته شده، بیشترین قمر را دارد."
    },
]


async def seed_database():
    """افزودن سوالات نمونه به دیتابیس."""
    print("🔄 در حال اتصال به دیتابیس...")
    
    conn = await aiosqlite.connect(DATABASE_PATH)
    conn.row_factory = aiosqlite.Row
    
    # چک کردن تعداد سوالات موجود
    cursor = await conn.execute("SELECT COUNT(*) as count FROM questions")
    row = await cursor.fetchone()
    existing_count = row["count"] if row else 0
    
    print(f"📊 تعداد سوالات موجود: {existing_count}")
    
    # افزودن سوالات جدید
    added = 0
    for q in SAMPLE_QUESTIONS:
        try:
            await conn.execute(
                """INSERT INTO questions 
                   (text, option_a, option_b, option_c, option_d, correct_answer, explanation, category, difficulty, created_by)
                   VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)""",
                (q["text"], q["option_a"], q["option_b"], q["option_c"], 
                 q["option_d"], q["correct_answer"], q["explanation"], 
                 "عمومی", "medium", None)
            )
            added += 1
            print(f"  ✅ سوال {added}: {q['text'][:40]}...")
        except Exception as e:
            print(f"  ❌ خطا: {e}")
    
    await conn.commit()
    await conn.close()
    
    print(f"\n✅ تعداد {added} سوال به دیتابیس اضافه شد!")
    print(f"📊 مجموع سوالات: {existing_count + added}")


if __name__ == "__main__":
    asyncio.run(seed_database())
